/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote.common;

import cz.insophy.inplan.remote.common.WorkplaceCalendarRequest;
import java.io.Serializable;
import java.util.List;

public class WorkplaceCalendarInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String workplaceName;
    private final List<TemplateDescription> templates;

    public WorkplaceCalendarInformation(String workplaceName, List<TemplateDescription> templates) {
        this.workplaceName = workplaceName;
        this.templates = templates;
    }

    public String getWorkplaceName() {
        return this.workplaceName;
    }

    public List<TemplateDescription> getTemplates() {
        return this.templates;
    }

    public static class TemplateDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String description;
        private final WorkplaceCalendarRequest.RequestType requestType;

        public TemplateDescription(String name, String description, WorkplaceCalendarRequest.RequestType requestType) {
            if (name == null) {
                throw new IllegalArgumentException("Template name must not be null.");
            }
            if (description == null) {
                description = "";
            }
            if (requestType == null) {
                throw new IllegalArgumentException("Request type must not be null.");
            }
            this.name = name;
            this.description = description;
            this.requestType = requestType;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public WorkplaceCalendarRequest.RequestType getRequestType() {
            return this.requestType;
        }

        public String toString() {
            if (this.description.length() == 0 || this.name.equals(this.description)) {
                return this.name;
            }
            return this.name + " - " + this.description;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TemplateDescription)) {
                return false;
            }
            TemplateDescription that = (TemplateDescription)o;
            return this.name.equals(that.name) && this.description.equals(that.description) && this.requestType == that.requestType;
        }
    }
}

